//+------------------------------------------------------------------+
//|                          Quantitative Qualitative Esmitation.mq4 |
//|                                                           goover |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "goover"
#property link      ""

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 8
#property  indicator_color1  Blue
#property  indicator_color2  Green
#property  indicator_color3  Red
//---- indicator parameters
extern int SF=5;
extern int RSI_P=14;
extern int Wilder_MA=14;

//---- indicator buffers
double   RSIndex[];
double   RSI[];
double   TrRSIFast[];
double   TrRSISlow[];
double   TR[];
double   ATRRSI[];
double   DeltaATRRSI_1[];
double   DeltaATRRSI_2[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(8);
//---- drawing settings
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,2);
   SetIndexDrawBegin(0,0);
   
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,2);
   SetIndexDrawBegin(1,0);
   
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,2);
   SetIndexDrawBegin(2,0);
   
   if(!SetIndexBuffer(0,RSIndex) &&
      !SetIndexBuffer(1,TrRSIFast) &&
      !SetIndexBuffer(2,TrRSISlow) &&
      !SetIndexBuffer(3,TR) &&
      !SetIndexBuffer(4,ATRRSI) &&
      !SetIndexBuffer(5,DeltaATRRSI_1) &&
      !SetIndexBuffer(6,DeltaATRRSI_2) &&
      !SetIndexBuffer(7,RSI))
      Print("Cannot set indicator buffers!");
   
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+2);

//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("QQE");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Moving Average of Oscillator                                     |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars=IndicatorCounted();
   double TH,TL;
   
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   
   for(int i=0; i<limit; i++){
      RSI[i]=iRSI(NULL,0,RSI_P,PRICE_CLOSE,i);
   }
   
   for(i=0; i<limit; i++){
      RSIndex[i]=iMAOnArray(RSI,Bars,SF,0,MODE_EMA,i);
   }
   
   for(i=0; i<limit; i++){
      if(RSIndex[i+1] > RSIndex[i])
         TH=RSIndex[i+1];
      else
         TH=RSIndex[i];
         
      if(RSIndex[i+1] < RSIndex[i])
         TL=RSIndex[i+1];
      else
         TL=RSIndex[i];
      
      TR[i]=TH-TL;
   }
   
   for(i=0; i<limit; i++){
      ATRRSI[i]=iMAOnArray(TR,Bars,Wilder_MA*2-1,0,MODE_EMA,i);
   }
   
   for(i=0; i<limit; i++){
      DeltaATRRSI_1[i]=iMAOnArray(ATRRSI,Bars,Wilder_MA*2-1,0,MODE_EMA,i)*2.618;
   }
   
   for(i=0; i<limit; i++){
      DeltaATRRSI_2[i]=iMAOnArray(ATRRSI,Bars,Wilder_MA*2-1,0,MODE_EMA,i)*4.236;
   }
   
   for(i=0; i<limit; i++){
      if(RSIndex[i]==RSIndex[i+1])
         TrRSIFast[i] = TrRSIFast[i+1];
      else if(RSIndex[i+1]<RSIndex[i-2] && RSIndex[i]<RSIndex[i+1])
               if((RSIndex[i] + DeltaATRRSI_1[i]) < (RSIndex[i+1] + DeltaATRRSI_1[i+1]))
                  TrRSIFast[i] = RSIndex[i] + DeltaATRRSI_1[i];
               else
                  TrRSIFast[i] = RSIndex[i+1] + DeltaATRRSI_1[i+1];
      else if(RSIndex[i+1]>RSIndex[i-2] && RSIndex[i]>RSIndex[i+1])
               if((RSIndex[i] - DeltaATRRSI_1[i]) > (RSIndex[i+1] - DeltaATRRSI_1[i+1]))
                  TrRSIFast[i] = RSIndex[i] - DeltaATRRSI_1[i];
               else
                  TrRSIFast[i] = RSIndex[i+1] - DeltaATRRSI_1[i+1];
      else if(RSIndex[i]>RSIndex[i+1])
               TrRSIFast[i] = RSIndex[i] - DeltaATRRSI_1[i];
            else
               TrRSIFast[i] = RSIndex[i] + DeltaATRRSI_1[i];
                  
   }
   
   for(i=0; i<limit; i++){
      if(RSIndex[i]==RSIndex[i+1])
         TrRSISlow[i] = TrRSISlow[i+1];
      else if(RSIndex[i+1]<RSIndex[i-2] && RSIndex[i]<RSIndex[i+1])
               if((RSIndex[i] + DeltaATRRSI_2[i]) < (RSIndex[i+1] + DeltaATRRSI_2[i+1]))
                  TrRSISlow[i] = RSIndex[i] + DeltaATRRSI_2[i];
               else
                  TrRSISlow[i] = RSIndex[i+1] + DeltaATRRSI_2[i+1];
      else if(RSIndex[i+1]>RSIndex[i-2] && RSIndex[i]>RSIndex[i+1])
               if((RSIndex[i] - DeltaATRRSI_2[i]) > (RSIndex[i+1] - DeltaATRRSI_2[i+1]))
                  TrRSISlow[i] = RSIndex[i] - DeltaATRRSI_2[i];
               else
                  TrRSISlow[i] = RSIndex[i+1] - DeltaATRRSI_2[i+1];
      else if(RSIndex[i]>RSIndex[i+1])
               TrRSISlow[i] = RSIndex[i] - DeltaATRRSI_2[i];
            else
               TrRSISlow[i] = RSIndex[i] + DeltaATRRSI_2[i];
                  
   }
   
   return(0);
  }
//+------------------------------------------------------------------+